/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	edma_init.h.c
  \brief    	DMA function definitions.
  \author   	Freescale Semiconductor
  \author       r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      0.1
  \date     	4/17/2008 
  
  * History:
  
*/
/****************************************************************************************/

#ifndef __EDMA_H__
 #define __EDMA_H__
   
  #include "Derivative.h"
  #include "Adc_Cfg.h"
  
  /** DMA channel assigned to handle ADC CFIFO queues */
  #define DMA_ADC_CFIFO_CHANNEL    (uint8_t)0
  /** DMA channel assigned to handle ADC RFIFO queues */
  #define DMA_ADC_RFIFO_CHANNEL    (uint8_t)1
    /** Source number of CFIFO 0 (DMA_MUX number)     */
  #define ADC_DMA_CFIFO0_SOURCE   (uint8_t)0x32
  /** Source number of RFIFO 0 (DMA_MUX number)       */
  #define ADC_DMA_RFIFO0_SOURCE   (uint8_t)0x31
  /** Source number of CFIFO 1 (DMA_MUX number)     */
  #define ADC_DMA_CFIFO1_SOURCE   (uint8_t)0x34
  /** Source number of RFIFO 1 (DMA_MUX number)       */
  #define ADC_DMA_RFIFO1_SOURCE   (uint8_t)0x33
  /** Enable DMA channel X                             */
  #define ENABLE_DMA_CHANNEL(channel)         EDMA.SERQR.R = channel;
  /** writes to INTC Priority register                 */
  #define SET_INTERRUPT_PRIORITY(u8IntNum,u8Priority)   INTC.PSR[u8IntNum].R = (uint8_t)u8Priority;
  /*--------------------- Function Definitions ----------------------------------------*/
  void vfnedma_init (void);
  void vfndma_config_fcn(void);


  extern uint32_t cQUEUE0;      /* CFIFO 0 Queue Variable declaration */
  extern vuint16_t rQUEUE0[12];    /* RFIFO 0 Queue Variable declaration */
  extern vuint32_t cQUEUE1[1];    /* CFIFO 1 Queue Variable declaration */
  extern vuint16_t rQUEUE1[1];    /* RFIFO 1 Queue Variable declaration */
  extern vuint32_t cQUEUE2[1];    /* CFIFO 2 Queue Variable declaration */
  extern vuint16_t rQUEUE2[1];    /* RFIFO 2 Queue Variable declaration */
  extern vuint32_t cQUEUE3[1];    /* CFIFO 3 Queue Variable declaration */
  extern vuint16_t rQUEUE3[1];    /* RFIFO 3 Queue Variable declaration */
  extern vuint32_t cQUEUE4[1];    /* CFIFO 4 Queue Variable declaration */
  extern vuint16_t rQUEUE4[1];    /* RFIFO 4 Queue Variable declaration */
  extern vuint32_t cQUEUE5[1];    /* CFIFO 5 Queue Variable declaration */
  extern vuint16_t rQUEUE5[1];  

  extern uint32_t cQUEUE[4];   
  
#endif
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

